//
//  ViewController.m
//  macOSSampleApp
//
//  Created by Eigendev on 2025-08-15.
//

#import "ViewController.h"
#import <Shift4RestAPISDK/Shift4RestAPISDK.h>

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];

    S4Request *s4Request = [[S4Request alloc] init];
    
    [s4Request setConfig:@"LogEnabled" fieldValue:@"n"];
    
    [s4Request setConfig:@"Mode" mode:S4ModeHostDirect];
    [s4Request setConfig:@"Method" method:S4MethodPOST];
    [s4Request setConfig:@"Host" fieldValue:@"https://api.shift4test.com"];
    [s4Request setConfig:@"URLPath" fieldValue:@"/api/rest/v1/transactions/sale"];
    
    [s4Request setHeader:@"InterfaceVersion" fieldValue:@"3.0"];
    [s4Request setHeader:@"InterfaceName" fieldValue:@"AppleSDK"];
    [s4Request setHeader:@"CompanyName" fieldValue:@"Shift4"];
    
    [s4Request setHeader:@"AccessToken" fieldValue:@"29CEDBCC-CC87-4AEF-B698-80296C52D9EF"];
    
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ"];
    
    [s4Request setRequest: @{
        @"amount": @{
            @"tax": @1.00,
            @"total": @11.00,
        },
        @"dateTime": [dateFormatter stringFromDate:[NSDate date]],
        @"apiOptions": @[
            @"ALLOWPARTIALAUTH"
        ],
        @"clerk": @{
            @"numericId": @"12345"
        },
        @"transaction": @{
          @"invoice": @"6820973"
        },
        @"card": @{
          @"entryMode": @"M",
          @"number": @"4444333322221111",
          @"expirationDate": @"1229",
          @"securityCode": @{
            @"indicator": @"1",
            @"value": @"333"
          }
        },
        @"customer": @{},
        @"postalCode": @"89000"
    }];
            
    NSLog(@"Processing Transaction");
    
    [s4Request process:^(S4Response *s4Response) {
        // Process complete async callback
        NSLog(@"Completed Transaction");
        if ([s4Response getHttpStatusCode] == 200) {
            NSDictionary *responseData = [s4Response getResponse];
            if (responseData[@"result"][0][@"transaction"][@"responseCode"] != nil) {
                NSLog(@"Response Code: %@", responseData[@"result"][0][@"transaction"][@"responseCode"]);
            }
            if (responseData[@"result"][0][@"transaction"][@"authorizationCode"] != nil) {
                NSLog(@"Authorization Code: %@", responseData[@"result"][0][@"transaction"][@"authorizationCode"]);
            }
        } else {
            NSLog(@"Error: %ld", [s4Response getHttpStatusCode]);
            NSLog(@"Error Response: %@", [s4Response getHttpError]);
            if ([s4Response getRequiresAudit]) {
                NSLog(@"Transaction Requires Audit");
                // Developer needs to add this transaction to a list that requires manual audit
                // See https://docs.shift4.com/guides/response-handling/timeouts-and-communications-failures

            }
        }
    }];
}


- (void)setRepresentedObject:(id)representedObject {
    [super setRepresentedObject:representedObject];

    // Update the view, if already loaded.
}


@end
