//
//  S4Request.h
//  Shift4RestAPISDK
//
//  Created by Eigendev on 2025-07-23.
//

#import <Foundation/Foundation.h>
#import <Shift4RestAPISDK/S4Method.h>
#import <Shift4RestAPISDK/S4Mode.h>
#import <Shift4RestAPISDK/S4Response.h>
#import <Shift4RestAPISDK/S4LogVerbosity.h>
#import <Shift4RestAPISDK/RestApiSdkLogger.h>
#import <Shift4RestAPISDK/S4Constants.h>


@interface S4Request : NSObject

@property (nonnull) RestApiSdkLogger *logger;
@property (nonnull) NSDictionary<NSString *, id> *request;
@property (nonnull) NSString *host;
@property (nonnull) NSString *port;
@property (nonnull) NSString *urlPath;
@property (atomic, strong, nonnull) NSMutableDictionary<NSString *, NSString *> *headers;
@property NSInteger timeout;
@property S4Mode mode;
@property S4Method method;
@property BOOL versionLogged;
@property NSTimeInterval invoiceLookupWaitTime;
@property (atomic, copy, nonnull) void (^completionHandler)(S4Response * _Nonnull response);

- (nullable instancetype)init;
- (void)setConfig:(nonnull NSString *)fieldName fieldValue:(nonnull NSString *)fieldValue;
- (void)setConfig:(nonnull NSString *)fieldName mode:(S4Mode)mode;
- (void)setConfig:(nonnull NSString *)fieldName method:(S4Method)method;
- (void)setConfig:(nonnull NSString *)fieldName verbosity:(S4LogVerbosity)verbosity;
- (void)setHeader:(nonnull NSString *)fieldName fieldValue:(nonnull NSString *)fieldValue;
- (void)process:(void (^_Nonnull)(S4Response * _Nonnull s4Response))completionHandler;
- (void)setRequest:(NSDictionary<NSString *, id> * _Nonnull)request;
- (BOOL)getIsInvoiceLookupSupported;

@end
