//
//  RestApiSdkLogger.h
//  Shift4RestAPISDK
//
//  Created by Eigendev on 2025-07-24.
//

#import <Foundation/Foundation.h>
#import <Shift4RestAPISDK/S4LogVerbosity.h>


@interface RestApiSdkLogger : NSObject

@property(atomic) BOOL logEnabled;
@property BOOL rollLog;
@property(atomic, nonnull) NSString *logPath;
@property(atomic) S4LogVerbosity logLevel;
@property(atomic, strong, nonnull) NSRegularExpression *t1Pattern;
@property(atomic, strong, nonnull) NSRegularExpression *t2Pattern;
@property(atomic, strong, nonnull) NSRegularExpression *panPattern;

- (nullable instancetype)init;
+ (nonnull NSString *)maskPattern:(nonnull NSString *)data regex:(nonnull NSRegularExpression *)regex;
- (void)log:(nonnull NSString *)source message:(nonnull NSString *)message logLevel:(S4LogVerbosity)logLevel;
- (void)rollLogFile;

@end
