//
//  S4Response.h
//  S4RestAPI
//
//  Created by Eigendev on 2025-07-10.
//

#import <Foundation/Foundation.h>
#import <Shift4RestAPISDK/S4ResponseWrapper.h>


@interface S4Response : NSObject

@property (nullable) NSDictionary<NSString *, id> *response;
@property (nonnull) NSDictionary<NSString *, NSString *> *httpHeaders;
@property BOOL isHttpError;
@property NSInteger httpStatusCode;
@property (nullable) NSString *httpErrorStr;
@property BOOL isCommunicationError;
@property BOOL requiresAudit;

- (nullable instancetype)initWithResponseWrapper:(nullable S4ResponseWrapper *)responseWrapper;
- (nullable instancetype)initWithException:(nonnull NSError *) error httpStatusCode:(NSInteger) httpStatusCode;
- (nullable instancetype)init;
- (nullable NSDictionary<NSString *, id> *)getResponse;
- (nonnull NSDictionary<NSString *, NSString *> *)getHeaders;
- (NSInteger)getHttpStatusCode;
- (nullable NSString *)getHttpError;
- (BOOL)isCommunicationErrorCode;
- (void)setRequiresAudit:(BOOL)requiresAudit;
- (BOOL)getRequiresAudit;

@end
