//
//  ViewController.m
//  iOSSampleApp
//
//  Created by Eigendev on 2025-08-15.
//

#import "ViewController.h"
#import <Shift4RestAPISDK/Shift4RestAPISDK.h>


@interface ViewController ()

@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self processShift4Transcation];
}

- (void)processShift4Transcation {
    S4Request *s4Request = [[S4Request alloc] init];
    
    [s4Request setConfig:@"LogEnabled" fieldValue:@"n"];
    
    [s4Request setConfig:@"Mode" mode:S4ModeHostDirect];
    [s4Request setConfig:@"Method" method:S4MethodPOST];
    [s4Request setConfig:@"Host" fieldValue:@"https://api.shift4test.com"];
    [s4Request setConfig:@"URLPath" fieldValue:@"/api/rest/v1/transactions/sale"];
    
    [s4Request setHeader:@"InterfaceVersion" fieldValue:@"3.0"];
    [s4Request setHeader:@"InterfaceName" fieldValue:@"AppleSDK"];
    [s4Request setHeader:@"CompanyName" fieldValue:@"Shift4"];
    
    [s4Request setHeader:@"AccessToken" fieldValue:@"29CEDBCC-CC87-4AEF-B698-80296C52D9EF"];
    
    NSDateFormatter *dateFormatter = [[NSDateFormatter alloc] init];
    [dateFormatter setDateFormat:@"yyyy-MM-dd'T'HH:mm:ss.SSSZZZZZ"];
    
    [s4Request setRequest: @{
        @"amount": @{
            @"tax": @1.00,
            @"total": @11.00,
        },
        @"dateTime": [dateFormatter stringFromDate:[NSDate date]],
        @"apiOptions": @[
            @"ALLOWPARTIALAUTH"
        ],
        @"clerk": @{
            @"numericId": @"12345"
        },
        @"transaction": @{
          @"invoice": @"6820973"
        },
        @"card": @{
          @"entryMode": @"M",
          @"number": @"4444333322221111",
          @"expirationDate": @"1229",
          @"securityCode": @{
            @"indicator": @"1",
            @"value": @"333"
          }
        },
        @"customer": @{},
        @"postalCode": @"89000"
    }];
    
    
    [self.StatusField setText:@"Processing Transaction..."];
    
    [s4Request process:^(S4Response *s4Response) {
        // Process complete async callback
        [self.StatusField setText:@"Completed Transaction"];
        
        if ([s4Response getHttpStatusCode] == 200) {
            NSDictionary *responseData = [s4Response getResponse];
            if (responseData[@"result"][0][@"transaction"][@"responseCode"] != nil) {
                NSString *responseCode = responseData[@"result"][0][@"transaction"][@"responseCode"];
                [self setResponseCodeFieldText:responseCode];
            }
            if (responseData[@"result"][0][@"transaction"][@"authorizationCode"] != nil) {
                NSString *authCode = responseData[@"result"][0][@"transaction"][@"authorizationCode"];
                [self setAuthCodeFieldText:authCode];
            }
            [self setHTTPStatusFieldText:@"200"];
        } else {
            [self setHTTPStatusFieldText:[NSString stringWithFormat:@"%ld", [s4Response getHttpStatusCode]]];
            [self setErrorFieldText:[s4Response getHttpError]];
            [self.AuthCodeField setText:@""];
            [self.ResponseCodeField setText:@""];
            
            if ([s4Response getRequiresAudit]) {
                [self.StatusField setText:@"Transaction Requires Audit"];
                
                // Developer needs to add this transaction to a list that requires manual audit
                // See https://docs.shift4.com/guides/response-handling/timeouts-and-communications-failures
            }
        }
    }];
}

- (void)setHTTPStatusFieldText:(NSString *)label {
    [self.HTTPStatusField setText:[NSString stringWithFormat:@"HTTP Status: %@", label]];
}

- (void)setResponseCodeFieldText:(NSString *)label {
    [self.ResponseCodeField setText:[NSString stringWithFormat:@"Response Code: %@", label]];
}

- (void)setAuthCodeFieldText:(NSString *)label {
    [self.AuthCodeField setText:[NSString stringWithFormat:@"Auth Code: %@", label]];
}

- (void)setErrorFieldText:(NSString *)text {
    [self.ErrorTextView setText:[NSString stringWithFormat:@"Error Response: %@", text]];
}

@end
