

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

import com.shift4.s4restapi.*;

public class S4JavaSample {
	public static void main(String[] args) {
		S4Request s4Request = new S4Request();

		s4Request.setConfig("Mode", S4Mode.HOST_DIRECT);
		s4Request.setConfig("Method", S4Method.POST);
		s4Request.setConfig("Host", "https://api.shift4test.com");
		s4Request.setConfig("URLPath", "/api/rest/v1/transactions/sale");
		

		s4Request.setHeader("InterfaceVersion", "2.1");
		s4Request.setHeader("InterfaceName", "RestAPIJavaSdk");
		s4Request.setHeader("CompanyName", "Shift4");
		s4Request.setHeader("AccessToken", "29CEDBCC-CC87-4AEF-B698-80296C52D9EF");

		S4DynamicObject dRequest = new S4DynamicObject();

		String formattedDateTime = ZonedDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX"));

		dRequest.setValue("dateTime", formattedDateTime);
		S4DynamicObject amount = new S4DynamicObject();
		amount.setValue("tax",      1.00);
		amount.setValue("total",    11.00);
		dRequest.setValue("amount", amount);

		S4DynamicObject[] apiOptions = new S4DynamicObject[1];
		apiOptions[0] = new S4DynamicObject();
		apiOptions[0].setValue("ALLOWPARTIALAUTH");
		dRequest.setValue("apiOptions", apiOptions);

		S4DynamicObject clerk = new S4DynamicObject();
		clerk.setValue("numericId", "12345");
		dRequest.setValue("clerk", clerk);

		S4DynamicObject transaction = new S4DynamicObject();
		transaction.setValue("invoice", "12345");
		dRequest.setValue("transaction", transaction);

		S4DynamicObject card = new S4DynamicObject();
		card.setValue("entryMode",       "M");
		card.setValue("number",          "4444333322221111");
		card.setValue("expirationDate",  1229);
		
		S4DynamicObject securityCode = new S4DynamicObject();
		securityCode.setValue("indicator", "1");
		securityCode.setValue("value",     "333");
		card.setValue("securityCode", securityCode);
		dRequest.setValue("card", card);

		S4DynamicObject customer = new S4DynamicObject();
		customer.setValue("postalCode", "89000");
		dRequest.setValue("customer",   customer);

		s4Request.setRequest(dRequest);
		System.out.println("Processing Transaction");
		S4Response s4Response = s4Request.process();
		S4DynamicObject resultObj = s4Response.getResponse();
		if (s4Response.getHttpStatusCode() == 200)
		{
			if (resultObj.isSet("result[0].transaction.responseCode"))
				System.out.println("Response Code:" + resultObj.getArray("result")[0].getObject("transaction").getString("responseCode"));
			if (resultObj.isSet("result[0].transaction.authorizationCode"))
				System.out.println("Response Code:" + resultObj.getArray("result")[0].getObject("transaction").getString("authorizationCode"));
		}
		else
		{
			System.out.println("Error:" + s4Response.getHttpStatusCode());
			System.out.println("Error Response:" + resultObj.toLog());

			if (s4Response.getRequiresAudit())
			{
				System.out.println("Transaction Requires Audit");
				//Developer needs to add this transaction to a list that requires manual audit
				//See https://myportal.shift4.com/index.cfm?action=development.shift4api#section/Logging-Communication-Failures-for-Auditor-Review
			}
		}

		System.out.println("Complete");
	}
}